<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Blog extends Model 
{

    protected $table = 'blogs';
    public $timestamps = true;
    protected $fillable = array('title_ar', 'title_en', 'desc_ar', 'desc_en', 'speciality_id');

    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'photoable');
    }

    public function speciality()
    {
        return $this->belongsTo('App\Models\Speciality');
    }

    public function tags()
    {
        return $this->belongsToMany('App\Models\Tag');
    }

}